<?php
// Pastikan header() berada di bagian paling atas sebelum ada output apapun
header('Content-Type: text/html; charset=UTF-8');
date_default_timezone_set('Asia/Dhaka'); // Bangladesh
error_reporting(E_ALL); ini_set('display_errors', 1);

// Menyimpan posisi brand yang terakhir diproses
$lastProcessedFile = 'last_processed.txt'; // File untuk menyimpan posisi terakhir diproses

// Cek apakah file last_processed.txt ada
if (file_exists($lastProcessedFile)) {
    $lastProcessedBrand = (int)file_get_contents($lastProcessedFile); // Ambil posisi terakhir diproses
} else {
    $lastProcessedBrand = 0; // Jika file tidak ada, mulai dari brand pertama
}

// ===== Helper Function =====
function createSlug($text) {
    $slug = strtolower($text);
    $slug = preg_replace('/[^a-z0-9\s-]/', '', $slug);
    $slug = preg_replace('/[\s-]+/', '-', $slug);
    return trim($slug, '-');
}

function logMsg($msg, $type = "info") {
    $color = ["success"=>"#38a169","error"=>"#e53e3e","warning"=>"#d69e2e","info"=>"#3182ce"][$type] ?? "#333";
    echo "<div style='color:$color;margin-bottom:6px;font-size:1.02em;'>$msg</div>";
    if (ob_get_level()) ob_flush(); flush();
}

// ===== Check Input Files =====
$requiredFiles = [
    'data.txt','template.php'
];
$missing = [];
foreach($requiredFiles as $f) if(!file_exists($f)) $missing[] = $f;
if($missing) die("File berikut tidak ditemukan:<br><code>".implode('</code>, <code>',$missing)."</code>");

// ===== LOAD DATA DARI data.txt =====
$data = file_get_contents('data.txt');
$lines = explode("\n", $data);

// Inisialisasi kategori data
$categories = [
    'BRAND' => [],
    'IMAGES' => [],
    'TITLE' => [],
    'DESCRIPTION' => [],
    'H2-1' => [],
    'PARAGRAF-H2-1' => [],
    'H2-2' => [],
    'PARAGRAF-H2-2' => [],
    'H2-3' => [],
    'PARAGRAF-H2-3' => [],
    'H2-4' => [],
    'PARAGRAF-H2-4' => [],
    'TITLE-HOME' => [],
    'DESCRIPTION-HOME' => [],
    'H2-1-HOME' => [],
    'PARAGRAF-H2-1-HOME' => [],
    'H2-2-HOME' => [],
    'PARAGRAF-H2-2-HOME' => [],
    'H2-3-HOME' => [],
    'PARAGRAF-H2-3-HOME' => [],
    'H2-4-HOME' => [],
    'PARAGRAF-H2-4-HOME' => [],
    'FAQ-QUESTION' => [],
    'FAQ-ANSWER' => []
];

// Proses baris data dan masukkan ke kategori yang sesuai
$currentCategory = '';
foreach ($lines as $line) {
    $line = trim($line);
    if (empty($line)) continue;

    // Menentukan kategori berdasarkan identifier
    if (strpos($line, '###') === 0) {
        $currentCategory = substr($line, 3);  // Ambil kategori setelah '###'
    } else {
        if (!empty($currentCategory)) {
            $categories[$currentCategory][] = $line;
        }
    }
}

if(empty($categories['BRAND'])) die("Brand data tidak ditemukan dalam data.txt!");

// ====== Prepare Output ======
$baseFolder = __DIR__; // Output di root script
$domain = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost');
$scriptDir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '\\');
$baseUrl = $domain . ($scriptDir ? "$scriptDir" : '') . "/";

// Log untuk generator
echo "<div style='font-family:sans-serif;background:#fafaff;padding:30px;max-width:900px;margin:24px auto;border-radius:15px;box-shadow:0 4px 32px #2222'>";
echo "<h2 style='font-weight:800;color:#764ba2;'>🚀 Generator</h2>";



// ===== BRAND =====
$brandSlugMap = [];
$sitemapPages = [$baseUrl]; // Pastikan URL base ditambahkan dulu

$brandsToProcess = array_slice($categories['BRAND'], $lastProcessedBrand); // Ambil dari brand terakhir yang diproses

foreach ($brandsToProcess as $bIdx => $brand) {
    file_put_contents($lastProcessedFile, $bIdx + $lastProcessedBrand + 1); // Update posisi brand yang sedang diproses

    $brand = trim($brand);
    $slugBrand = createSlug($brand);
    $folderBrand = "$baseFolder/$slugBrand";
    if (!is_dir($folderBrand)) mkdir($folderBrand,0755,true);

    // Ambil data untuk brand
    $brandName = strtoupper($brand);
    $pageTitleRaw = $categories['TITLE'][array_rand($categories['TITLE'])];
    $pageDescRaw = $categories['DESCRIPTION'][array_rand($categories['DESCRIPTION'])];
    $pageTitle = str_replace(['$brandName', '{{BRAND}}'], $brandName, $pageTitleRaw);
    $pageDesc = str_replace(['$brandName', '{{BRAND}}'], $brandName, $pageDescRaw);
    $pageImage = $categories['IMAGES'][array_rand($categories['IMAGES'])];
    $canonicalUrl = $baseUrl . $slugBrand . '/index.html';
    $sitemapPages[] = $canonicalUrl; // Pastikan URL brand dimasukkan ke sitemap
    // Ambil data FAQ
    $faqQuestions = $categories['FAQ-QUESTION'];  // Daftar pertanyaan FAQ
    $faqAnswers = $categories['FAQ-ANSWER'];     // Daftar jawaban FAQ

    // Brand
    // H2-1, H2-2, H2-3, H2-4 dan paragrafnya
    $pageH2_1 = $categories['H2-1'];  // Ambil semua data H2-1
    $pageParagrafH2_1 = $categories['PARAGRAF-H2-1'];  // Ambil semua paragraf H2-1

    $pageH2_2 = $categories['H2-2'];  // Ambil semua data H2-2
    $pageParagrafH2_2 = $categories['PARAGRAF-H2-2'];  // Ambil semua paragraf H2-2

    $pageH2_3 = $categories['H2-3'];  // Ambil semua data H2-3
    $pageParagrafH2_3 = $categories['PARAGRAF-H2-3'];  // Ambil semua paragraf H2-3

    $pageH2_4 = $categories['H2-4'];  // Ambil semua data H2-4
    $pageParagrafH2_4 = $categories['PARAGRAF-H2-4'];  // Ambil semua paragraf H2-4

    // Ganti {{BRAND}} dengan nama brand di seluruh bagian H2 dan paragraf
    $pageH2_1 = array_map(function($h2) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $h2);
    }, $pageH2_1);

    $pageParagrafH2_1 = array_map(function($para) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $para);
    }, $pageParagrafH2_1);

    // Proses untuk H2-2, H2-3, H2-4, dan paragrafnya
    $pageH2_2 = array_map(function($h2) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $h2);
    }, $categories['H2-2']);
    $pageParagrafH2_2 = array_map(function($para) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $para);
    }, $categories['PARAGRAF-H2-2']);

    $pageH2_3 = array_map(function($h2) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $h2);
    }, $categories['H2-3']);
    $pageParagrafH2_3 = array_map(function($para) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $para);
    }, $categories['PARAGRAF-H2-3']);

    $pageH2_4 = array_map(function($h2) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $h2);
    }, $categories['H2-4']);
    $pageParagrafH2_4 = array_map(function($para) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $para);
    }, $categories['PARAGRAF-H2-4']);

    // Ganti {{BRAND}} pada FAQ
    $faqQuestions = array_map(function($q) use ($brandName) {
    return str_replace('{{BRAND}}', $brandName, $q);
    }, $categories['FAQ-QUESTION']);
    
    $faqAnswers = array_map(function($a) use ($brandName) {
        return str_replace('{{BRAND}}', $brandName, $a);
    }, $categories['FAQ-ANSWER']);

    // Ambil data secara acak tanpa mendefinisikan jumlah
    $pageH2_1 = (count($pageH2_1) > 0) ? $pageH2_1[array_rand($pageH2_1)] : ''; 
    $pageParagrafH2_1 = (count($pageParagrafH2_1) > 0) ? $pageParagrafH2_1[array_rand($pageParagrafH2_1)] : '';

    $pageH2_2 = (count($pageH2_2) > 0) ? $pageH2_2[array_rand($pageH2_2)] : ''; 
    $pageParagrafH2_2 = (count($pageParagrafH2_2) > 0) ? $pageParagrafH2_2[array_rand($pageParagrafH2_2)] : '';

    $pageH2_3 = (count($pageH2_3) > 0) ? $pageH2_3[array_rand($pageH2_3)] : ''; 
    $pageParagrafH2_3 = (count($pageParagrafH2_3) > 0) ? $pageParagrafH2_3[array_rand($pageParagrafH2_3)] : '';

    $pageH2_4 = (count($pageH2_4) > 0) ? $pageH2_4[array_rand($pageH2_4)] : ''; 
    $pageParagrafH2_4 = (count($pageParagrafH2_4) > 0) ? $pageParagrafH2_4[array_rand($pageParagrafH2_4)] : '';

    // Misalnya kita hanya akan ambil 5 pertanyaan pertama dan jawabannya
    $faqData = [];
    for ($i = 0; $i < min(5, count($faqQuestions)); $i++) {
        $faqData[] = [
            'question' => $faqQuestions[$i],
            'answer' => $faqAnswers[$i]
        ];
    }

    // Siapkan variabel FAQ untuk template
    $faq = $faqData;

    // Mulai buffer, **inject cloaking di paling atas**
    ob_start();
    include 'template.php'; // Memanggil template.php untuk setiap brand
    $content = ob_get_clean();
    file_put_contents("$folderBrand/index.html", $content);

    logMsg("Brand: <code>/$slugBrand/index.html</code>", 'success');
}

// ===== LEVEL 1: HOMEPAGE =====


// ===== LEVEL 1: HOMEPAGE (buat config + sematkan kode home.php) =====
$pageTitleHome = $categories['TITLE-HOME'][array_rand($categories['TITLE-HOME'])] ?? '';
$pageDescHome  = $categories['DESCRIPTION-HOME'][array_rand($categories['DESCRIPTION-HOME'])] ?? '';
$pageImage     = $categories['IMAGES'][array_rand($categories['IMAGES'])] ?? 'https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp';

$canonicalUrl = rtrim($baseUrl, '/') . '/index.php';

// 1) Siapkan blok PHP config di atas index.html
$cfgPhp  = "<?php\n";
$cfgPhp .= "header('Content-Type: text/html; charset=UTF-8');\n";
$cfgPhp .= '$pageTitleHome         = ' . var_export($pageTitleHome, true) . ";\n";
$cfgPhp .= '$pageDescHome          = ' . var_export($pageDescHome, true) . ";\n";
$cfgPhp .= '$pageImage             = ' . var_export($pageImage, true) . ";\n";
$cfgPhp .= '$canonicalUrl          = ' . var_export($canonicalUrl, true) . ";\n";
$cfgPhp .= "?>\n";

// 2) Ambil source code home.php untuk disematkan utuh di bawah config
$homeSrc = file_get_contents(__DIR__ . '/home.php');

// 3) Tulis index.html yang berisi config + kode home.php (tetap dinamis)
file_put_contents($baseFolder . '/index.php', $cfgPhp . $homeSrc);

logMsg("Homepage <b>index.php</b> dibuat dengan menyematkan kode home.php (dinamis).", 'success');



// ===== SITEMAP.XML (MERGE + REMOVE DUPLICATE) =====
logMsg("Menggabungkan dan memperbarui sitemap.xml...",'warning');
$sitemapFile = __DIR__.'/sitemap.xml';
$existingUrls = [];

// Baca sitemap.xml lama jika ada
if (file_exists($sitemapFile)) {
    $xml = simplexml_load_file($sitemapFile);
    foreach ($xml->url as $url) {
        $loc = (string)$url->loc;
        $existingUrls[] = $loc;
    }
}

// ===== SITEMAP.XML (FULL REGENERATE, SCAN FOLDER) =====
logMsg("Generate sitemap.xml (full scan folder)...",'warning');
$sitemapFile = __DIR__ . '/sitemap.xml';

// --- Fungsi scan semua index.html di subfolder ---
function scanAllPages($baseUrl, $baseDir) {
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($baseDir));
    $urls = [];
    foreach ($rii as $file) {
        if ($file->isDir()) continue;
        if ($file->getFilename() == 'index.html') {
            // Ambil path relatif
            $relPath = str_replace($baseDir, '', $file->getPath());
            // Buat URL (handle root)
            $url = rtrim($baseUrl, '/') . str_replace('\\', '/', $relPath) . '/';
            // Pastikan hanya ada satu slash di tengah
            $url = preg_replace('#([^:])//+#', '\\1/', $url);
            $urls[] = $url;
        }
    }
    // Tambahkan homepage di awal (pastikan unik)
    array_unshift($urls, $baseUrl);
    return array_values(array_unique($urls));
}

$allUrls = scanAllPages($baseUrl, $baseFolder);

$sitemap = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
$sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
foreach ($allUrls as $url) {
    // Cek file fisik index.html
    $relPath = rtrim(str_replace($baseUrl, '', $url), '/');
    $filePath = $relPath ? ($baseFolder . '/' . $relPath . '/index.html') : ($baseFolder . '/index.html');
    $lastmod = file_exists($filePath) ? date('c', filemtime($filePath)) : date('c');
    $sitemap .= "  <url>\n";
    $sitemap .= "    <loc>" . htmlspecialchars($url) . "</loc>\n";
    $sitemap .= "    <lastmod>" . $lastmod . "</lastmod>\n";
    $sitemap .= "    <changefreq>daily</changefreq>\n";
    $sitemap .= "    <priority>1</priority>\n";
    $sitemap .= "  </url>\n";
}
$sitemap .= "</urlset>\n";

file_put_contents($sitemapFile, $sitemap);
logMsg("File <b>sitemap.xml</b> sudah diupdate (full scan, lengkap).",'success');


// ===== ROBOTS.TXT =====
logMsg("Membuat robots.txt...",'warning');
$robots = "User-agent: *\nAllow: /\n\nSitemap: ".$baseUrl."sitemap.xml\n";
file_put_contents(__DIR__.'/robots.txt', $robots);
logMsg("File <b>robots.txt</b> dibuat.",'success');

// ===== Auto Delete .txt & Script =====
logMsg("Menghapus semua .txt, generator.php, cloack.php, home.php, template.php",'warning');
$filesDel = glob('*.txt');
$filesDel = array_merge($filesDel, ['generator.php', 'home.php', 'template.php','cloack.php']);
$filesDel = array_filter($filesDel, function($f){
    return !in_array($f, ['robots.txt','sitemap.xml']);
});
$deleted=[];$notdeleted=[];
foreach($filesDel as $f){
    if(is_file($f)){
        if(@unlink($f)) $deleted[]=$f;
        else $notdeleted[]=$f;
    }
}
echo "<div style='margin:12px 0 10px 0'>";
if($deleted){
    echo "✅ <b>Terhapus:</b> <code>".implode("</code>, <code>",$deleted)."</code><br>";
}
if($notdeleted){
    echo "❌ <b>Gagal hapus:</b> <code>".implode("</code>, <code>",$notdeleted)."</code> (cek permission)<br>";
}
echo "</div>";

logMsg("<b>Selesai generate!</b><br>Brand: ".count($brandsToProcess),'success');
echo "<div style='background:linear-gradient(90deg,#48bb78,#38a169);padding:18px;margin-top:30px;border-radius:8px;color:#fff;text-align:center'><b>Semua halaman & sitemap sudah siap. Folder ini bisa langsung diupload ke hosting utama!</b></div>";
echo "</div>";
?>