<?php
header('Content-Type: text/html; charset=UTF-8');
$pageTitleHome         = '- মোবাইলে রিওয়ার্ড জিতুন ক্যাসিনো খেলায়';
$pageDescHome          = 'login করলেই অফিসিয়াল app খুলে casino খেলুন, প্রথম bet এ দারুণ পুরস্কার ও অফার পেয়ে গেমিং মজা নিন।';
$pageImage             = 'https://ik.imagekit.io/sm88/tunnel-brand/assets/images/SM88-Free-300-Spins.webp';
$canonicalUrl          = 'https://smi-platform.org/casino/index.php';
?>
<?php
/**
 * Enhanced Homepage with Casino Style & Internal Linking
 * Adapted from promotional website design
 */

// Get all directories (generated pages)
$directories = array_filter(glob('*'), 'is_dir');
$directories = array_filter($directories, function($dir) {
    return file_exists($dir . '/index.html') && $dir !== '.' && $dir !== '..';
});

// Sort alphabetically
sort($directories);

// Search functionality
$searchQuery = isset($_GET['search']) ? trim($_GET['search']) : '';
$filteredDirectories = $directories;

if (!empty($searchQuery)) {
    $filteredDirectories = array_filter($directories, function($dir) use ($searchQuery) {
        return stripos($dir, $searchQuery) !== false;
    });
}

// Pagination settings
$itemsPerPage = 6; // Ubah dari 12 menjadi 6
$currentPage = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$totalItems = count($filteredDirectories);
$totalPages = ceil($totalItems / $itemsPerPage);
$offset = ($currentPage - 1) * $itemsPerPage;
$currentItems = array_slice($filteredDirectories, $offset, $itemsPerPage);

// Preserve search query in pagination
$queryString = !empty($searchQuery) ? '&search=' . urlencode($searchQuery) : '';

// Generate random countdown times for each brand
function generateCountdownTime($index) {
    $days = rand(1, 30);
    $hours = rand(0, 23);
    $minutes = rand(0, 59);
    $seconds = rand(0, 59);
    
    $futureTime = time() + ($days * 24 * 60 * 60) + ($hours * 60 * 60) + ($minutes * 60) + $seconds;
    return date('Y-m-d\TH:i:s', $futureTime);
}

// Brand promotion titles and descriptions
$promoTitles = [
    "বড় স্পিন অফার",
    "বোনাস জিতুন এখন",
    "হট ফায়ার স্পিন",
    "গোল্ডেন জ্যাকপট টাইম",
    "লাকি স্পিন জিতুন",
    "দ্রুত জয় করুন",
    "বড় বোনাস টাইম",
    "সুপার জেতার সুযোগ",
    "বড় স্পিন রিওয়ার্ড",
    "আজই জিতুন",
    "জ্যাকপট ধরুন",
    "সুপার স্পিন জিতুন",
    "লাকি টাইম চলছে",
    "রিওয়ার্ড টাইম এখন",
    "স্পিন করে জিতুন",
    "আজই ক্যাশ বোনাস",
    "বড় জয় আপনার",
    "সোনালী সুযোগ এখন",
    "স্পিন করে নিন পুরস্কার",
    "গোল্ড টাইম বোনাস",
    "লাকি জয় আজই",
    "রিওয়ার্ড নিন এখন",
    "বড় অফার চলছে",
    "বড় জয় অপেক্ষায়",
    "বোনাস টাইম শুরু",
    "দ্রুত জয় শুরু",
    "বড় স্পিন অফার",
    "লাকি টাইম শুরু",
    "আজই পুরস্কার জিতুন",
    "গোল্ডেন জয় টাইম",
    "বড় অফার এখনই",
    "স্পিন করলেই জয়",
    "লাকি জয় টাইম",
    "সুপার জয় অফার",
    "স্পিন টাইম এখন",
    "আজই স্পিন করুন",
    "রিওয়ার্ড টাইম চলছে",
    "জিতুন এখনই",
    "বোনাস অফার চলছে",
    "দ্রুত জয় অফার",
    "গোল্ডেন বোনাস জয়",
    "বড় সুযোগ এখন",
    "লাকি স্পিন টাইম",
    "বোনাস সময় শুরু",
    "স্পিন করুন জয় করুন",
    "আজই জয় করুন",
    "সোনালী সময় এখন",
    "বড় অফার জিতুন",
    "লাকি জয় শুরু",
    "বোনাস পুরস্কার নিন",
    "লাকি বোনাস টাইম",
    "দ্রুত জয় করুন",
    "বড় অফার চলছে",
    "স্পিন করে জিতুন",
    "আজই জিতুন পুরস্কার",
    "রিওয়ার্ড টাইম শুরু",
    "বোনাস সময় চলছে",
    "লাকি স্পিন অফার",
    "জ্যাকপট ধরুন আজই",
    "সোনালী জয় সময়",
    "বড় স্পিন শুরু",
    "দ্রুত অফার ধরুন",
    "বোনাস নিন এখন",
    "স্পিন অফার চলছে",
    "আজই জয় শুরু",
    "বড় জয় সময়",
    "লাকি সুযোগ আজই",
    "সোনালী অফার এখন",
    "স্পিন করে নিন পুরস্কার",
    "বোনাস সময় শুরু",
    "দ্রুত জয় সময়",
    "রিওয়ার্ড অফার ধরুন",
    "বড় জয় অফার",
    "লাকি সময় এখন",
    "সোনালী জয় অফার",
    "বোনাস সময় এখন",
    "স্পিন অফার ধরুন",
    "আজই রিওয়ার্ড নিন",
    "দ্রুত অফার সময়",
    "লাকি বোনাস শুরু",
    "বড় জয় ধরুন",
    "বোনাস ধরুন এখন",
    "স্পিন করুন জয় করুন",
    "সোনালী সময় শুরু",
    "রিওয়ার্ড এখনই",
    "বড় অফার আজই",
    "দ্রুত জয় ধরুন",
    "লাকি জয় সময়",
    "স্পিন সময় শুরু",
    "বোনাস জয় সময়",
    "আজই স্পিন করুন",
    "সোনালী সময় ধরুন",
    "লাকি রিওয়ার্ড সময়",
    "বোনাস জয় শুরু",
    "রিওয়ার্ড ধরুন আজই",
    "বড় জয় এখনই",
    "দ্রুত স্পিন করুন",
    "লাকি অফার শুরু",
    "স্পিন করে জয়",
    "বোনাস ধরুন আজই",
    "বড় জয় সময়",
    "লাকি সুযোগ ধরুন",
    "বোনাস অফার ধরুন",
    "স্পিন করুন এখনই",
    "সোনালী সময় ধরুন",
    "রিওয়ার্ড সময় শুরু",
    "দ্রুত অফার ধরুন",
    "বড় জয় শুরু",
    "লাকি স্পিন টাইম",
    "বোনাস জয় সময়",
    "স্পিন অফার শুরু",
    "আজই জয় সময়",
    "দ্রুত জয় শুরু",
    "বড় সুযোগ আজই",
    "লাকি অফার ধরুন",
    "রিওয়ার্ড নিন এখন",
    "বোনাস সময় ধরুন",
    "স্পিন সময় এখন",
    "সোনালী অফার ধরুন",
    "লাকি জয় শুরু",
    "বড় অফার ধরুন",
    "রিওয়ার্ড অফার শুরু",
    "স্পিন করে জয় করুন",
    "বোনাস জয় ধরুন",
    "দ্রুত সময় ধরুন",
    "লাকি জয় সময়",
    "বড় রিওয়ার্ড সময়",
    "সোনালী সময় চলছে",
    "স্পিন করুন জয় করুন",
    "বোনাস অফার চলছে",
    "দ্রুত জয় ধরুন",
    "লাকি স্পিন শুরু",
    "বড় জয় এখনই",
    "রিওয়ার্ড ধরুন এখন",
    "বোনাস শুরু আজই",
    "স্পিন অফার সময়",
    "লাকি সুযোগ শুরু",
    "বড় বোনাস শুরু",
    "রিওয়ার্ড জয় সময়",
    "দ্রুত জয় সময়",
    "লাকি জয় ধরুন",
    "বড় অফার আজই",
    "বোনাস অফার আজই",
    "স্পিন টাইম শুরু",
    "লাকি অফার সময়",
    "বড় জয় অফার",
    "রিওয়ার্ড জয় ধরুন",
    "বোনাস ধরুন আজই",
    "স্পিন জয় সময়",
    "সোনালী সময় শুরু",
    "বড় অফার সময়",
    "লাকি জয় অফার",
    "বোনাস সময় চলছে",
    "স্পিন অফার ধরুন",
    "সোনালী সুযোগ এখন",
    "রিওয়ার্ড সময় আজই",
    "দ্রুত অফার এখন",
    "লাকি বোনাস ধরুন",
    "বড় জয় সময় এখন",
    "স্পিন করুন আজই",
    "বোনাস সুযোগ ধরুন",
    "রিওয়ার্ড জয় সময়",
    "দ্রুত জয় সময়",
    "লাকি স্পিন শুরু",
    "বড় অফার শুরু",
    "বোনাস টাইম শুরু",
    "সোনালী জয় সময়",
    "স্পিন করুন জয় করুন",
    "লাকি অফার চলছে",
    "রিওয়ার্ড টাইম চলছে",
    "দ্রুত সুযোগ ধরুন",
    "বড় জয় সুযোগ",
    "বোনাস অফার ধরুন",
    "স্পিন অফার শুরু",
    "লাকি জয় ধরুন",
    "সোনালী অফার সময়",
    "রিওয়ার্ড জয় শুরু",
    "দ্রুত জয় ধরুন",
    "বোনাস সুযোগ এখন",
    "স্পিন সময় ধরুন",
    "লাকি রিওয়ার্ড সময়",
    "বড় জয় চলছে",
    "বোনাস জয় সময়",
    "স্পিন জয় সময়",
    "লাকি অফার এখন",
    "দ্রুত জয় সুযোগ",
    "বড় অফার চলছে",
    "বোনাস অফার শুরু",
    "স্পিন অফার সময়",
    "সোনালী জয় অফার",
    "লাকি জয় শুরু",
    "রিওয়ার্ড সুযোগ ধরুন",
    "দ্রুত সময় শুরু",
    "বড় জয় অফার",
    "বোনাস ধরুন এখন",
    "স্পিন সময় এখন",
    "লাকি টাইম এখন",
    "রিওয়ার্ড অফার ধরুন",
    "বোনাস জয় ধরুন",
    "দ্রুত অফার ধরুন",
    "বড় জয় ধরুন",
    "লাকি সময় এখন",
    "বোনাস জয় শুরু",
    "স্পিন অফার চলছে",
    "সোনালী সুযোগ ধরুন",
    "রিওয়ার্ড সময় এখন",
    "দ্রুত জয় করুন",
    "লাকি অফার ধরুন",
    "বড় বোনাস ধরুন",
    "স্পিন জয় শুরু",
    "বোনাস টাইম চলছে",
    "রিওয়ার্ড অফার শুরু",
    "দ্রুত অফার শুরু",
    "লাকি জয় টাইম",
    "বড় সময় শুরু",
    "বোনাস অফার সময়",
    "স্পিন করে জয়",
    "সোনালী সময় চলছে",
    "রিওয়ার্ড টাইম শুরু",
    "দ্রুত জয় শুরু",
    "লাকি সুযোগ শুরু",
    "বড় জয় অফার",
    "বোনাস ধরুন আজই",
    "স্পিন টাইম চলছে",
    "লাকি বোনাস টাইম",
    "সোনালী জয় সময়",
    "রিওয়ার্ড অফার চলছে",
    "দ্রুত সময় ধরুন",
    "বড় জয় সময়",
    "বোনাস সময় শুরু",
    "স্পিন করুন জয় করুন",
    "লাকি অফার সময়",
    "সোনালী অফার ধরুন",
    "রিওয়ার্ড জয় এখন",
    "দ্রুত অফার আজই",
    "বড় সুযোগ ধরুন",
    "বোনাস জয় এখন",
    "স্পিন জয় শুরু",
    "লাকি টাইম শুরু",
    "রিওয়ার্ড অফার সময়",
    "দ্রুত জয় সুযোগ",
    "বড় বোনাস সময়",
    "লাকি স্পিন টাইম",
    "বোনাস অফার ধরুন",
    "স্পিন সময় শুরু",
    "সোনালী সময় এখন",
    "রিওয়ার্ড ধরুন এখন",
    "দ্রুত জয় টাইম",
    "বড় অফার ধরুন",
    "লাকি জয় অফার",
    "লাকি অফার শুরু",
    "বড় সময় এখন",
    "বোনাস সময় ধরুন",
    "স্পিন টাইম ধরুন",
    "সোনালী সুযোগ শুরু",
    "রিওয়ার্ড অফার আজই",
    "দ্রুত জয় শুরু",
    "লাকি জয় সময়",
    "বড় অফার এখন",
    "স্পিন অফার শুরু",
    "বোনাস জয় সময়",
    "রিওয়ার্ড সময় শুরু",
    "দ্রুত জয় সময়",
    "লাকি সুযোগ আজই",
    "বড় জয় শুরু",
    "বোনাস অফার এখন",
    "স্পিন জয় সময়",
    "সোনালী অফার এখন",
    "রিওয়ার্ড ধরুন আজই",
    "দ্রুত সুযোগ ধরুন",
    "লাকি অফার আজই",
    "বড় জয় সময়",
    "বোনাস টাইম এখন",
    "স্পিন অফার আজই",
    "লাকি টাইম ধরুন",
    "সোনালী জয় শুরু",
    "রিওয়ার্ড টাইম এখন",
    "দ্রুত অফার ধরুন",
    "বড় বোনাস অফার",
    "বোনাস জয় এখন",
    "স্পিন করুন এখনই",
    "লাকি জয় অফার",
    "সোনালী সুযোগ ধরুন",
    "রিওয়ার্ড অফার এখন",
    "দ্রুত জয় ধরুন",
    "বড় সময় শুরু",
    "বোনাস অফার চলছে",
    "স্পিন টাইম এখন",
    "লাকি সুযোগ ধরুন",
    "সোনালী অফার শুরু",
    "রিওয়ার্ড জয় সময়",
    "দ্রুত অফার শুরু",
    "বড় জয় অফার",
    "বোনাস অফার শুরু",
    "স্পিন করুন জয় করুন",
    "লাকি জয় শুরু",
    "সোনালী সময় শুরু",
    "রিওয়ার্ড ধরুন এখন",
    "দ্রুত সুযোগ শুরু",
    "বড় বোনাস টাইম"
];

$promoDescriptions = [
    "বড় স্পিন অফার - আজই স্পিন করে জিতুন!",
    "বোনাস জিতুন এখন - বড় বোনাস আপনার জন্য",
    "হট ফায়ার স্পিন - দ্রুত জয় শুরু করুন",
    "গোল্ডেন জ্যাকপট টাইম - সোনালী সময় এখন",
    "লাকি স্পিন জিতুন - লাকি সুযোগ ধরুন",
    "দ্রুত জয় করুন - জিতুন এখনই!",
    "বড় বোনাস টাইম - অফার মিস করবেন না",
    "সুপার জেতার সুযোগ - আজই জয় করুন",
    "বড় স্পিন রিওয়ার্ড - দারুণ পুরস্কার আপনার জন্য",
    "আজই জিতুন - লাকি সময় চলছে",
    "জ্যাকপট ধরুন - সোনালী জয় অপেক্ষায়",
    "সুপার স্পিন জিতুন - স্পিন করে পুরস্কার নিন",
    "লাকি টাইম চলছে - দ্রুত জয় করুন এখনই",
    "রিওয়ার্ড টাইম এখন - রিওয়ার্ড দাবি করুন",
    "স্পিন করে জিতুন - এক ক্লিকে জয়",
    "আজই ক্যাশ বোনাস - বোনাস ধরুন এখনই",
    "বড় জয় আপনার - লাকি স্পিন করুন",
    "সোনালী সুযোগ এখন - মিস না করার সুযোগ",
    "স্পিন করে নিন পুরস্কার - লাকি সময় শুরু",
    "গোল্ড টাইম বোনাস - সোনালী জয় অফার",
    "লাকি জয় আজই - লাকি স্পিন শুরু",
    "রিওয়ার্ড নিন এখন - রিওয়ার্ড ধরুন দ্রুত",
    "বড় অফার চলছে - সীমিত সময়ের অফার",
    "বড় জয় অপেক্ষায় - দ্রুত জয় করুন",
    "বোনাস টাইম শুরু - আজই জয় করুন",
    "দ্রুত জয় শুরু - লাকি টাইম এখনই",
    "বড় স্পিন অফার - স্পিন করে জয় করুন",
    "লাকি টাইম শুরু - অফার ধরুন এখনই",
    "আজই পুরস্কার জিতুন - সোনালী সুযোগ ধরুন",
    "গোল্ডেন জয় টাইম - লাকি অফার চলছে",
    "বড় অফার এখনই - সময় নষ্ট করবেন না",
    "স্পিন করলেই জয় - স্পিন করে নিন জয়",
    "লাকি জয় টাইম - লাকি সময় চলছে",
    "সুপার জয় অফার - আজই জয় করুন",
    "স্পিন টাইম এখন - রিওয়ার্ড ধরুন এখন",
    "আজই স্পিন করুন - লাকি অফার এখন",
    "রিওয়ার্ড টাইম চলছে - সোনালী সুযোগ এখন",
    "জিতুন এখনই - অফার ধরুন দ্রুত",
    "বোনাস অফার চলছে - বড় অফার মিস না করুন",
    "দ্রুত জয় অফার - আজই জয় করুন",
    "গোল্ডেন বোনাস জয় - সোনালী সময় শুরু",
    "বড় সুযোগ এখন - লাকি সুযোগ ধরুন",
    "লাকি স্পিন টাইম - স্পিন করুন এখন",
    "বোনাস সময় শুরু - বোনাস অফার চলছে",
    "স্পিন করুন জয় করুন - আজই জয় শুরু",
    "আজই জয় করুন - সোনালী সময় চলছে",
    "সোনালী সময় এখন - লাকি অফার শুরু",
    "বড় অফার জিতুন - আজই জয় করুন",
    "লাকি জয় শুরু - স্পিন করুন দ্রুত",
    "বোনাস পুরস্কার নিন - রিওয়ার্ড ধরুন এখনই",
    "লাকি বোনাস টাইম - লাকি সুযোগ এখনই",
    "দ্রুত জয় করুন - আজই জয় শুরু করুন",
    "বড় অফার চলছে - সময় নষ্ট করবেন না",
    "স্পিন করে জিতুন - এক ক্লিকে জয়",
    "আজই জিতুন পুরস্কার - রিওয়ার্ড ধরুন দ্রুত",
    "রিওয়ার্ড টাইম শুরু - বড় সুযোগ এখন",
    "বোনাস সময় চলছে - অফার মিস করবেন না",
    "লাকি স্পিন অফার - লাকি সময় শুরু",
    "জ্যাকপট ধরুন আজই - জয় অপেক্ষায় আপনার",
    "সোনালী জয় সময় - সোনালী অফার এখন",
    "বড় স্পিন শুরু - স্পিন করুন এখনই",
    "দ্রুত অফার ধরুন - সীমিত সময়ের অফার",
    "বোনাস নিন এখন - রিওয়ার্ড শুরু করুন",
    "স্পিন অফার চলছে - আজই জয় করুন",
    "আজই জয় শুরু - অফার ধরুন দ্রুত",
    "বড় জয় সময় - জয় আপনার হাতে",
    "লাকি সুযোগ আজই - লাকি স্পিন করুন",
    "সোনালী অফার এখন - বড় জয় সময়",
    "স্পিন করে নিন পুরস্কার - লাকি অফার ধরুন",
    "বোনাস সময় শুরু - আজই জয় শুরু",
    "দ্রুত জয় সময় - স্পিন করুন দ্রুত",
    "রিওয়ার্ড অফার ধরুন - রিওয়ার্ড দাবি করুন",
    "বড় জয় অফার - অফার চলছে এখন",
    "লাকি সময় এখন - সোনালী অফার ধরুন",
    "সোনালী জয় অফার - রিওয়ার্ড সময় এখন",
    "বোনাস সময় এখন - বোনাস ধরুন আজই",
    "স্পিন অফার ধরুন - দ্রুত জয় করুন",
    "আজই রিওয়ার্ড নিন - লাকি টাইম চলছে",
    "দ্রুত অফার সময় - বড় সুযোগ ধরুন",
    "লাকি বোনাস শুরু - স্পিন করে জয় করুন",
    "বড় জয় ধরুন - অফার মিস করবেন না",
    "বোনাস ধরুন এখন - আজই জয় করুন",
    "স্পিন করুন জয় করুন - লাকি সময় চলছে",
    "সোনালী সময় শুরু - সোনালী অফার চলছে",
    "রিওয়ার্ড এখনই - রিওয়ার্ড ধরুন",
    "বড় অফার আজই - আজই জয় সময়",
    "দ্রুত জয় ধরুন - লাকি অফার চলছে",
    "লাকি জয় সময় - স্পিন অফার ধরুন",
    "স্পিন সময় শুরু - আজই জয় করুন",
    "বোনাস জয় সময় - রিওয়ার্ড সময় এখন",
    "আজই স্পিন করুন - লাকি জয় শুরু",
    "সোনালী সময় ধরুন - অফার মিস না করুন",
    "লাকি রিওয়ার্ড সময় - দ্রুত জয় শুরু",
    "বোনাস জয় শুরু - স্পিন করে জয়",
    "রিওয়ার্ড ধরুন আজই - সোনালী সুযোগ ধরুন",
    "বড় জয় এখনই - আজই জয় করুন",
    "দ্রুত স্পিন করুন - লাকি অফার ধরুন",
    "লাকি অফার শুরু - রিওয়ার্ড সময় চলছে",
    "স্পিন করে জয় - লাকি সুযোগ আজই",
    "বোনাস ধরুন আজই - স্পিন টাইম এখন",
    "বড় জয় সময় - আজই জয় করুন",
    "লাকি সুযোগ ধরুন - সোনালী সময় এখন",
    "বোনাস অফার ধরুন - বোনাস সময় চলছে",
    "স্পিন করুন এখনই - লাকি অফার ধরুন",
    "সোনালী সময় ধরুন - রিওয়ার্ড সময় এখন",
    "রিওয়ার্ড সময় শুরু - আজই জয় শুরু",
    "দ্রুত অফার ধরুন - সীমিত সময়ের অফার",
    "বড় জয় শুরু - স্পিন টাইম এখন",
    "লাকি স্পিন টাইম - লাকি জয় শুরু",
    "বোনাস জয় সময় - আজই জয় করুন",
    "স্পিন অফার শুরু - দ্রুত জয় করুন",
    "আজই জয় সময় - সোনালী সুযোগ এখন",
    "দ্রুত জয় শুরু - অফার ধরুন এখনই",
    "বড় সুযোগ আজই - রিওয়ার্ড নিন এখনই",
    "লাকি অফার ধরুন - স্পিন করে জয় করুন",
    "রিওয়ার্ড নিন এখন - রিওয়ার্ড শুরু করুন",
    "বোনাস সময় ধরুন - লাকি টাইম চলছে",
    "স্পিন সময় এখন - আজই জয় করুন",
    "সোনালী অফার ধরুন - সোনালী সময় এখন",
    "লাকি জয় শুরু - বোনাস ধরুন এখনই",
    "বড় অফার ধরুন - স্পিন টাইম শুরু",
    "রিওয়ার্ড অফার শুরু - দ্রুত জয় সময়",
    "স্পিন করে জয় করুন - লাকি সময় চলছে",
    "বোনাস জয় ধরুন - আজই অফার ধরুন",
    "দ্রুত সময় ধরুন - লাকি সুযোগ ধরুন",
    "লাকি জয় সময় - স্পিন অফার চলছে",
    "বড় রিওয়ার্ড সময় - রিওয়ার্ড ধরুন এখন",
    "সোনালী সময় চলছে - সোনালী সুযোগ ধরুন",
    "স্পিন করুন জয় করুন - দ্রুত জয় শুরু",
    "বোনাস অফার চলছে - আজই জয় করুন",
    "দ্রুত জয় ধরুন - বোনাস সময় শুরু",
    "লাকি স্পিন শুরু - লাকি জয় এখনই",
    "বড় জয় এখনই - স্পিন করুন আজই",
    "রিওয়ার্ড ধরুন এখন - লাকি টাইম শুরু",
    "বোনাস শুরু আজই - রিওয়ার্ড সময় এখন",
    "স্পিন অফার সময় - আজই জয় করুন",
    "লাকি সুযোগ শুরু - অফার ধরুন এখন",
    "বড় বোনাস শুরু - দ্রুত জয় করুন",
    "রিওয়ার্ড জয় সময় - স্পিন অফার ধরুন",
    "দ্রুত জয় সময় - সোনালী সময় চলছে",
    "লাকি জয় ধরুন - বোনাস অফার ধরুন",
    "বড় অফার আজই - রিওয়ার্ড সময় চলছে",
    "বোনাস অফার আজই - লাকি অফার ধরুন",
    "স্পিন টাইম শুরু - দ্রুত জয় সময়",
    "লাকি অফার সময় - আজই জয় করুন",
    "বড় জয় অফার - বড় সুযোগ ধরুন",
    "রিওয়ার্ড জয় ধরুন - লাকি স্পিন শুরু",
    "বোনাস ধরুন আজই - রিওয়ার্ড টাইম চলছে",
    "স্পিন জয় সময় - সোনালী জয় শুরু",
    "সোনালী সময় শুরু - অফার মিস করবেন না",
    "বড় অফার সময় - আজই অফার ধরুন",
    "লাকি জয় অফার - লাকি সময় চলছে",
    "বোনাস সময় চলছে - বোনাস ধরুন এখন",
    "স্পিন অফার ধরুন - স্পিন করুন এখনই",
    "সোনালী সুযোগ এখন - দ্রুত জয় করুন",
    "রিওয়ার্ড সময় আজই - রিওয়ার্ড ধরুন আজই",
    "দ্রুত অফার এখন - সীমিত সময়ের অফার",
    "লাকি বোনাস ধরুন - লাকি জয় শুরু",
    "বড় জয় সময় এখন - আজই জয় করুন",
    "স্পিন করুন আজই - রিওয়ার্ড সময় শুরু",
    "বোনাস সুযোগ ধরুন - বোনাস টাইম চলছে",
    "রিওয়ার্ড জয় সময় - স্পিন টাইম শুরু",
    "দ্রুত জয় সময় - লাকি টাইম চলছে",
    "লাকি স্পিন শুরু - অফার ধরুন এখনই",
    "বড় অফার শুরু - সোনালী সময় চলছে",
    "বোনাস টাইম শুরু - লাকি জয় ধরুন",
    "সোনালী জয় সময় - আজই স্পিন করুন",
    "স্পিন করুন জয় করুন - রিওয়ার্ড সময় এখন",
    "লাকি অফার চলছে - লাকি সুযোগ ধরুন",
    "রিওয়ার্ড টাইম চলছে - স্পিন করুন আজই",
    "দ্রুত সুযোগ ধরুন - দ্রুত জয় করুন",
    "বড় জয় সুযোগ - সোনালী সময় শুরু",
    "বোনাস অফার ধরুন - রিওয়ার্ড সময় চলছে",
    "স্পিন অফার শুরু - বোনাস টাইম চলছে",
    "লাকি জয় ধরুন - আজই জয় সময়",
    "সোনালী অফার সময় - লাকি অফার এখন",
    "রিওয়ার্ড জয় শুরু - স্পিন করুন এখনই",
    "দ্রুত জয় ধরুন - রিওয়ার্ড ধরুন আজই",
    "বোনাস সুযোগ এখন - লাকি জয় সময়",
    "স্পিন সময় ধরুন - বোনাস অফার ধরুন",
    "লাকি রিওয়ার্ড সময় - লাকি অফার শুরু",
    "বড় জয় চলছে - আজই জয় করুন",
    "বোনাস জয় সময় - রিওয়ার্ড অফার চলছে",
    "স্পিন জয় সময় - স্পিন অফার এখন",
    "লাকি অফার এখন - বড় সুযোগ ধরুন",
    "দ্রুত জয় সুযোগ - লাকি জয় ধরুন",
    "বড় অফার চলছে - রিওয়ার্ড সময় এখন",
    "বোনাস অফার শুরু - আজই জয় শুরু",
    "স্পিন অফার সময় - সোনালী সময় চলছে",
    "সোনালী জয় অফার - রিওয়ার্ড অফার শুরু",
    "লাকি জয় শুরু - দ্রুত জয় সময়",
    "রিওয়ার্ড সুযোগ ধরুন - লাকি সময় চলছে",
    "দ্রুত সময় শুরু - অফার ধরুন আজই",
    "বড় জয় অফার - লাকি টাইম এখন",
    "বোনাস ধরুন এখন - আজই জয় করুন",
    "স্পিন সময় এখন - রিওয়ার্ড শুরু করুন",
    "লাকি টাইম এখন - লাকি জয় সময়",
    "রিওয়ার্ড অফার ধরুন - বোনাস সময় চলছে",
    "বোনাস জয় ধরুন - স্পিন অফার এখন",
    "দ্রুত অফার ধরুন - সোনালী সময় এখন",
    "বড় জয় ধরুন - আজই জয় শুরু করুন",
    "লাকি সময় এখন - লাকি টাইম চলছে",
    "বোনাস জয় শুরু - বোনাস ধরুন এখনই",
    "স্পিন অফার চলছে - স্পিন করুন আজই",
    "সোনালী সুযোগ ধরুন - দ্রুত জয় করুন",
    "রিওয়ার্ড সময় এখন - রিওয়ার্ড অফার চলছে",
    "দ্রুত জয় করুন - লাকি সুযোগ ধরুন",
    "লাকি অফার ধরুন - বড় অফার এখনই",
    "বড় বোনাস ধরুন - আজই জয় সময়",
    "স্পিন জয় শুরু - লাকি সময় চলছে",
    "বোনাস টাইম চলছে - বোনাস ধরুন এখন",
    "রিওয়ার্ড অফার শুরু - আজই জয় করুন",
    "দ্রুত অফার শুরু - রিওয়ার্ড ধরুন আজই",
    "লাকি জয় টাইম - লাকি স্পিন শুরু",
    "বড় সময় শুরু - স্পিন টাইম চলছে",
    "বোনাস অফার সময় - বড় সুযোগ ধরুন",
    "স্পিন করে জয় - স্পিন করুন এখনই",
    "সোনালী সময় চলছে - সোনালী অফার ধরুন",
    "রিওয়ার্ড টাইম শুরু - রিওয়ার্ড সময় এখন",
    "দ্রুত জয় শুরু - আজই জয় করুন",
    "লাকি সুযোগ শুরু - লাকি অফার চলছে",
    "বড় জয় অফার - বড় সুযোগ এখন",
    "বোনাস ধরুন আজই - বোনাস অফার চলছে",
    "স্পিন টাইম চলছে - স্পিন করুন এখনই",
    "লাকি বোনাস টাইম - লাকি জয় সময়",
    "সোনালী জয় সময় - অফার ধরুন আজই",
    "রিওয়ার্ড অফার চলছে - রিওয়ার্ড শুরু করুন",
    "দ্রুত সময় ধরুন - লাকি অফার ধরুন",
    "বড় জয় সময় - আজই জয় করুন",
    "বোনাস সময় শুরু - বোনাস টাইম চলছে",
    "স্পিন করুন জয় করুন - স্পিন অফার ধরুন",
    "লাকি অফার সময় - লাকি সময় চলছে",
    "সোনালী অফার ধরুন - সোনালী জয় সময়",
    "রিওয়ার্ড জয় এখন - রিওয়ার্ড ধরুন এখনই",
    "দ্রুত অফার আজই - আজই জয় শুরু করুন",
    "বড় সুযোগ ধরুন - লাকি টাইম চলছে",
    "বোনাস জয় এখন - বোনাস ধরুন আজই",
    "স্পিন জয় শুরু - লাকি অফার চলছে",
    "লাকি টাইম শুরু - স্পিন অফার ধরুন",
    "রিওয়ার্ড অফার সময় - রিওয়ার্ড টাইম এখন",
    "দ্রুত জয় সুযোগ - আজই জয় করুন",
    "বড় বোনাস সময় - বোনাস টাইম চলছে",
    "লাকি স্পিন টাইম - লাকি সুযোগ এখনই",
    "বোনাস অফার ধরুন - রিওয়ার্ড সময় এখন",
    "স্পিন সময় শুরু - আজই স্পিন করুন",
    "সোনালী সময় এখন - সোনালী অফার চলছে",
    "রিওয়ার্ড ধরুন এখন - রিওয়ার্ড শুরু করুন",
    "দ্রুত জয় টাইম - অফার ধরুন দ্রুত",
    "বড় অফার ধরুন - লাকি টাইম শুরু",
    "লাকি জয় অফার - স্পিন করুন এখনই",
    "লাকি অফার শুরু - আজই অফার ধরুন",
    "বড় সময় এখন - দ্রুত জয় শুরু করুন",
    "বোনাস সময় ধরুন - বোনাস টাইম চলছে",
    "স্পিন টাইম ধরুন - স্পিন অফার চলছে",
    "সোনালী সুযোগ শুরু - লাকি সময় এখন",
    "রিওয়ার্ড অফার আজই - রিওয়ার্ড ধরুন এখনই",
    "দ্রুত জয় শুরু - লাকি অফার ধরুন",
    "লাকি জয় সময় - লাকি টাইম চলছে",
    "বড় অফার এখন - আজই জয় করুন",
    "স্পিন অফার শুরু - স্পিন করুন এখনই",
    "বোনাস জয় সময় - বোনাস ধরুন এখনই",
    "রিওয়ার্ড সময় শুরু - রিওয়ার্ড অফার চলছে",
    "দ্রুত জয় সময় - অফার ধরুন দ্রুত",
    "লাকি সুযোগ আজই - সোনালী সুযোগ ধরুন",
    "বড় জয় শুরু - আজই জয় শুরু করুন",
    "বোনাস অফার এখন - বোনাস টাইম চলছে",
    "স্পিন জয় সময় - স্পিন অফার ধরুন",
    "সোনালী অফার এখন - সোনালী জয় সময়",
    "রিওয়ার্ড ধরুন আজই - রিওয়ার্ড টাইম চলছে",
    "দ্রুত সুযোগ ধরুন - দ্রুত জয় করুন",
    "লাকি অফার আজই - লাকি টাইম চলছে",
    "বড় জয় সময় - লাকি অফার ধরুন",
    "বোনাস টাইম এখন - বোনাস সময় চলছে",
    "স্পিন অফার আজই - স্পিন করুন এখনই",
    "লাকি টাইম ধরুন - সোনালী সময় শুরু",
    "সোনালী জয় শুরু - রিওয়ার্ড ধরুন আজই",
    "রিওয়ার্ড টাইম এখন - রিওয়ার্ড সময় শুরু",
    "দ্রুত অফার ধরুন - দ্রুত জয় সময়",
    "বড় বোনাস অফার - বোনাস ধরুন আজই",
    "বোনাস জয় এখন - বোনাস টাইম শুরু",
    "স্পিন করুন এখনই - স্পিন অফার চলছে",
    "লাকি জয় অফার - লাকি সময় চলছে",
    "সোনালী সুযোগ ধরুন - অফার মিস করবেন না",
    "রিওয়ার্ড অফার এখন - রিওয়ার্ড টাইম শুরু",
    "দ্রুত জয় ধরুন - আজই জয় করুন",
    "বড় সময় শুরু - লাকি অফার চলছে",
    "বোনাস অফার চলছে - বোনাস সময় শুরু",
    "স্পিন টাইম এখন - স্পিন করুন এখনই",
    "লাকি সুযোগ ধরুন - লাকি টাইম চলছে",
    "সোনালী অফার শুরু - সোনালী জয় সময়",
    "রিওয়ার্ড জয় সময় - রিওয়ার্ড ধরুন এখনই",
    "দ্রুত অফার শুরু - অফার চলছে এখন",
    "বড় জয় অফার - আজই জয় করুন",
    "বোনাস অফার শুরু - বোনাস টাইম এখন",
    "স্পিন করুন জয় করুন - লাকি টাইম চলছে",
    "লাকি জয় শুরু - স্পিন অফার ধরুন",
    "সোনালী সময় শুরু - রিওয়ার্ড সময় চলছে",
    "রিওয়ার্ড ধরুন এখন - আজই জয় শুরু",
    "দ্রুত সুযোগ শুরু - দ্রুত জয় সময়",
    "বড় বোনাস টাইম - বোনাস ধরুন এখনই"
];
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Primary Meta Tags -->
    <title>Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?></title>
    <meta name="title" content="Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?>" />
    <meta name="description" content="Casino <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?>" />
    <meta name="keywords" content="Casino" />
    <meta name="page:google.com" content="https://www.google.com/search?q=Casino" />
    <meta name="page:google.com.bd" content="https://www.google.com.bd/search?q=Casino" />
    <meta name="author" content="soyo" />
    <meta name="robots" content="index, follow" />
    <meta name="language" content="Bengali" />

    <!-- Canonical URL -->
    <link rel="canonical" href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" />

    <!-- Favicon -->
    <link rel="icon" type="image/webp" href="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/favicon-sm88.webp" />
    <link rel="apple-touch-icon" href="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/favicon-sm88.webp" />

    <!-- Image -->
    <meta property="og:image" content="<?= htmlspecialchars($pageImage, ENT_QUOTES, 'UTF-8') ?>"/>
    <meta name="og:image" content="<?= htmlspecialchars($pageImage, ENT_QUOTES, 'UTF-8') ?>"/>
    <meta property="og:image:secure_url" content="<?= htmlspecialchars($pageImage, ENT_QUOTES, 'UTF-8') ?>"/>
    <meta name="og:image:secure_url" content="<?= htmlspecialchars($pageImage, ENT_QUOTES, 'UTF-8') ?>"/>

    <!-- Open Graph / Facebook -->
    <meta property="og:site_name" content="Casino" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="og:title" content="Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="og:description" content="Casino <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="og:image" content="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" />
    <meta name="og:locale" content="bn_BD" />

    <!--Lang Language & Location-->
    <meta name="page-locale" content="bn_BD" />
    <meta name="language" content="bn" />
    <meta name="geo.region" content="BD" />
    <meta name="geo.country" content="BD" />
    <meta name="geo.placename" content="Dhaka" />
    <meta name="tgn.nation" content="Bangladesh" />

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image" />
    <meta property="twitter:url" content="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="twitter:title" content="Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="twitter:description" content="Casino <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="twitter:image" content="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" />

    <!-- Preconnect -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- CSS -->
    <link rel="stylesheet" href="https://ik.imagekit.io/soyo/BD/tunnel/asset2/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    

    <!-- Structured Data / JSON-LD -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": "Casino",
            "url": "<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>",
            "logo": "https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp",
            "sameAs": ["https://www.facebook.com/Casino", "https://twitter.com/Casino", "https://www.instagram.com/Casino"],
            "contactPoint": {
                "@type": "ContactPoint",
                "telephone": "+1234567890",
                "contactType": "customer service",
                "availableLanguage": ["Bengali"]
            },
            "address": {
                "@type": "PostalAddress",
                "streetAddress": "123 XXX Road, Gulshan",
                "addressLocality": "Dhaka",
                "addressRegion": "Dhaka Division",
                "postalCode": "1212",
                "addressCountry": "BD"
            },
            "description": "Casino <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?>"
        }
    </script>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebSite",
            "name": "Casino",
            "url": "<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>"
        }
    </script>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage",
            "url": "<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>",
            "name": "Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?>",
            "description": "Casino <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?>",
            "isPartOf": {
                "@type": "WebSite",
                "name": "Casino",
                "url": "<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>"
            },
            "about": {
                "@type": "Casino",
                "name": "Casino",
                "address": {
                    "@type": "PostalAddress",
                    "streetAddress": "123 Road, Gulshan",
                    "addressLocality": "Dhaka",
                    "addressRegion": "Dhaka Division",
                    "postalCode": "1212",
                    "addressCountry": "BD"
                }
            },
            "publisher": {
                "@type": "Organization",
                "name": "Casino"
            },
            "datePublished": "2025-10-03",
            "dateModified": "2025-10-03",
            "inLanguage": "bn-BD",
            "primaryImageOfPage": {
                "@type": "ImageObject",
                "url": "https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp"
            }
        }
    </script>
    <!--JSON Bread Crumb-->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "FAQPage",
            "mainEntity": [
                {
                    "@type": "Question",
                    "name": "কিভাবে আমি Casino তে একটি অ্যাকাউন্ট তৈরি করব?",
                    "acceptedAnswer": {
                        "@type": "Answer",
                        "text": "Casino তে অ্যাকাউন্ট তৈরি করা খুব সহজ। শুধু অফিসিয়াল ওয়েবসাইট বা অ্যাপ-এ যান, 'Sign Up' বাটনে ক্লিক করুন, প্রয়োজনীয় তথ্য দিন এবং ভেরিফাই করুন। কয়েক সেকেন্ডের মধ্যে লগইন করে বেট শুরু করতে পারবেন।"
                    }
                },
                {
                    "@type": "Question",
                    "name": "Casino লগইন প্রক্রিয়া কি নিরাপদ?",
                    "acceptedAnswer": {
                        "@type": "Answer",
                        "text": "্যাঁ, Casino শক্তিশালী এনক্রিপশন ও সিকিউর সার্ভার ব্যবহার করে। প্রতিটি লগইন সেশনে আপনার ডেটা সুরক্ষিত থাকে। এটি খেলোয়াড়দের জন্য একটি নির্ভরযোগ্য ও সেফ অভিজ্ঞতা তৈরি করে।"
                    }
                },

                {
                    "@type": "Question",
                    "name": "Casino অ্যাপ কোথা থেকে ডাউনলোড করবো?",
                    "acceptedAnswer": {
                        "@type": "Answer",
                        "text": "Casino অ্যাপ অফিসিয়াল ওয়েবসাইট থেকে নিরাপদে ডাউনলোড করা যায়। এই মোবাইল অ্যাপের মাধ্যমে খেলোয়াড়রা সহজেই লগইন করে ক্যাসিনো গেম ও বেট উপভোগ করতে পারেন।"
                    }
                },
                {
                    "@type": "Question",
                    "name": "আমি কি মোবাইল ফোনে Casino ব্যবহার করতে পারবো?",
                    "acceptedAnswer": {
                        "@type": "Answer",
                        "text": "অবশ্যই পারবেন! Casino অ্যাপ অ্যান্ড্রয়েড ও iOS উভয় ডিভাইসের জন্য অপ্টিমাইজ করা। এর মাধ্যমে আপনি যেকোনো জায়গা থেকে ক্যাসিনো গেমে বেট করতে পারবেন।"
                    }
                },
                {
                    "@type": "Question",
                    "name": "Casino কি লাইভ ক্যাসিনো সাপোর্ট করে",
                    "acceptedAnswer": {
                        "@type": "Answer",
                        "text": "হ্যাঁ, Casino লাইভ ডিলার টেবিল এবং রিয়েল টাইম ক্যাসিনো সাপোর্ট করে। খেলোয়াড়রা সহজে অ্যাপ বা ওয়েবসাইট থেকে লগইন করে লাইভ বেটিং উপভোগ করতে পারেন।"
                    }
                }
            ]
        }
    </script>
</head>

<body>
    <header class="site-header">
        <a href="#maincontent" class="skip-link">Skip to main content</a>
        <div class="header-container">
            <a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" aria-label="Homepage" class="site-logo-link">
                <img src="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" alt="Casino Casino Logo" title="Casino Casino Logo" class="site-logo-img">
            </a>
            <nav class="main-nav" aria-label="Main navigation">
                <ul class="nav-menu">
                    <li><a href="#login">বোনাস লগইন</a></li>
                    <li><a href="#app">মোবাইল অ্যাপটি ডাউনলোড করুন</a></li>
                    <li><a href="#casino">ক্যাসিনো গেম অনলাইন</a></li>
                    <li><a href="#bd">বাংলাদেশ বেটিং প্ল্যাটফর্ম</a></li>
                    <li><a href="#faq">FAQ</a></li>
                </ul>
            </nav>
            <button class="nav-toggle" aria-label="Open navigation" aria-expanded="false">
              <span class="bar"></span>
              <span class="bar"></span>
              <span class="bar"></span>
            </button>

        </div>
    </header>

    

    <main class="main-content" id="maincontent">

        
        
        <!-- SECTION H1 - Banner & Intro -->
        <section class="brand-header">
            <a href="https://sm88login.com/" title="Casino">
                <div class="brand-name">sm88login.com</div>
            </a>
            <h1 class="page-title">Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?></h1>
            <img src="<?= htmlspecialchars($pageImage, ENT_QUOTES, 'UTF-8') ?>"
                alt="Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?>"
                title="Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?>"
                class="featured-image"
                loading="lazy">
            <div class="content">
                <p><a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" title="Casino"><strong>Casino</strong></a> <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?></p>
            </div>
        </section>

        <section class="promotions-section">
            <div class="container">
                <h2 class="section-title">বিশ্বস্ত ব্র্যান্ডের উপর অফিসিয়াল প্রচারণা</h2>
                <p class="section-subtitle">এখনই আপনার মোবাইল অ্যাপ থেকে প্রতিদিন যেকোনো সময় আপনার বোনাস পান!</p>
                
                <!-- Search Box -->
                <div class="search-container">
                    <form method="GET" class="search-form">
                        <input type="text" name="search" class="search-box" placeholder="Search brands by name..." value="<?= htmlspecialchars($searchQuery) ?>" autocomplete="off">
                        <button type="submit" class="search-btn">🔍</button>
                    </form>
                </div>
                
                <div class="stats">
                    <?php if (!empty($searchQuery)): ?>
                        Found <strong><?= count($filteredDirectories) ?></strong> results for "<?= htmlspecialchars($searchQuery) ?>"
                        <a href="?" class="clear-search">Clear search</a>
                    <?php else: ?>
                        <strong><?= $totalItems ?></strong> amazing brands with exclusive offers
                    <?php endif; ?>
                </div>
                
                <?php if (!empty($currentItems)): ?>
                    <div class="promotion-cards-container">
                        <?php foreach ($currentItems as $index => $dir): ?>
                            <div class="promo-card">
                                <div class="card-header">
                                    <h3 class="brand-logo"><?= htmlspecialchars(strtoupper(str_replace(['-', '_'], ' ', $dir))) ?></h3>
                                </div>
                                <div class="card-body">
                                    <h4 class="promo-title"><?= $promoTitles[$index % count($promoTitles)] ?></h4>
                                    <p class="promo-description"><?= $promoDescriptions[$index % count($promoDescriptions)] ?></p>
                                    <div class="countdown-timer" data-end-time="<?= generateCountdownTime($index) ?>"></div>
                                </div>
                                <div class="card-footer">
                                    <a href="<?= htmlspecialchars($dir) ?>/" class="cta-button">Claim Now &rarr;</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="promotion-cards-container">
                        <div class="promo-card">
                            <div class="card-header">
                                <img src="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" alt="Casino Logo" class="brand-logo" />
                            </div>
                            <div class="card-body">
                                <h3 class="promo-title">Casino</h3>
                                <p class="promo-description">Trusted Betting & Gaming Experience in Bangladesh</p>
                                <div class="countdown-timer" data-end-time="2026-01-30T23:59:59"></div>
                            </div>
                            <div class="card-footer">
                                <a href="https://sm88login.com/" class="cta-button" title="Casino">Casino</a>
                            </div>
                        </div>
                        <div class="promo-card">
                            <div class="card-header">
                                <img src="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" alt="Casino Logo" class="brand-logo" />
                            </div>
                            <div class="card-body">
                                <h3 class="promo-title">Casino</h3>
                                <p class="promo-description">Trusted Betting & Gaming Experience in Bangladesh</p>
                                <div class="countdown-timer" data-end-time="2026-01-30T23:59:59"></div>
                            </div>
                            <div class="card-footer">
                                <a href="https://sm88game.com/" class="cta-button" title="Casino">Casino</a>
                            </div>
                        </div>
                        <div class="promo-card">
                            <div class="card-header">
                                <img src="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" alt="Casino Logo" class="brand-logo" />
                            </div>
                            <div class="card-body">
                                <h3 class="promo-title">Casino</h3>
                                <p class="promo-description">Premier Online Gaming in Bangladesh</p>
                                <div class="countdown-timer" data-end-time="2026-01-30T23:59:59"></div>
                            </div>
                            <div class="card-footer">
                                <a href="https://sm88win.com/en/" class="cta-button" title="Casino">Click Here</a>
                            </div>
                        </div>
                        <div class="promo-card">
                            <div class="card-header">
                                <img src="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" alt="Casino Logo" class="brand-logo" />
                            </div>
                            <div class="card-body">
                                <h3 class="promo-title">Casino</h3>
                                <p class="promo-description">Best Betting App Platform in Bangladesh</p>
                                <div class="countdown-timer" data-end-time="2026-01-30T23:59:59"></div>
                            </div>
                            <div class="card-footer">
                                <a href="https://sm888.pages.dev/" class="cta-button" title="Casino">Casino</a>
                            </div>
                        </div>
                    </div>

                    <?php if ($totalItems > 6): ?>
                        <button id="loadMoreBtn" class="load-more-button">আরও দেখান</button>
                    <?php endif; ?>
                    
                    <!-- Pagination -->
                    <?php if ($totalPages > 1): ?>
                        <div class="pagination">
                            <?php if ($currentPage > 1): ?>
                                <a href="?page=<?= $currentPage - 1 ?><?= $queryString ?>">← পূর্ববর্তী</a>
                            <?php endif; ?>
                            
                            <?php 
                            $startPage = max(1, $currentPage - 2);
                            $endPage = min($totalPages, $currentPage + 2);
                            
                            if ($startPage > 1): ?>
                                <a href="?page=1<?= $queryString ?>">1</a>
                                <?php if ($startPage > 2): ?>
                                    <span>...</span>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                                <?php if ($i == $currentPage): ?>
                                    <span class="current"><?= $i ?></span>
                                <?php else: ?>
                                    <a href="?page=<?= $i ?><?= $queryString ?>"><?= $i ?></a>
                                <?php endif; ?>
                            <?php endfor; ?>
                            
                            <?php if ($endPage < $totalPages): ?>
                                <?php if ($endPage < $totalPages - 1): ?>
                                    <span>...</span>
                                <?php endif; ?>
                                <a href="?page=<?= $totalPages ?><?= $queryString ?>"><?= $totalPages ?></a>
                            <?php endif; ?>
                            
                            <?php if ($currentPage < $totalPages): ?>
                                <a href="?page=<?= $currentPage + 1 ?><?= $queryString ?>">পরবর্তী →</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                <div class="no-results">
                    <?php if (!empty($searchQuery)): ?>
                        <h3 class="subheading">🔍 No brands found</h3>
                        <p>No brands match your search "<strong><?= htmlspecialchars($searchQuery) ?></strong>"</p>
                        <p>Try searching with different keywords</p>
                    <?php else: ?>
                        <h3>📁 No brands available</h3>
                        <p>No brands have been generated yet. Please run the generator first.</p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </section>

        <!-- SECTION FAQ -->
        <section class="faq-section" id="faq">
            <h2 class="faq-title">Frequently Asked Questions (FAQ)</h2>
            <div class="faq-list">
                <div class="faq-item">
                    <button class="faq-question" aria-expanded="false">
                        কিভাবে আমি Casino তে একটি অ্যাকাউন্ট তৈরি করব?
                        <span class="faq-arrow">&#9660;</span>
                    </button>
                    <div class="faq-answer">
                        Casino তে অ্যাকাউন্ট তৈরি করা খুব সহজ। শুধু অফিসিয়াল ওয়েবসাইট বা অ্যাপ-এ যান, 'Sign Up' বাটনে ক্লিক করুন, প্রয়োজনীয় তথ্য দিন এবং ভেরিফাই করুন। কয়েক সেকেন্ডের মধ্যে লগইন করে বেট শুরু করতে পারবেন।
                    </div>
                </div>
                <div class="faq-item">
                    <button class="faq-question" aria-expanded="false">
                        Casino লগইন প্রক্রিয়া কি নিরাপদ?
                        <span class="faq-arrow">&#9660;</span>
                    </button>
                    <div class="faq-answer">
                        ্যাঁ, Casino শক্তিশালী এনক্রিপশন ও সিকিউর সার্ভার ব্যবহার করে। প্রতিটি লগইন সেশনে আপনার ডেটা সুরক্ষিত থাকে। এটি খেলোয়াড়দের জন্য একটি নির্ভরযোগ্য ও সেফ অভিজ্ঞতা তৈরি করে।
                    </div>
                </div>
                <div class="faq-item">
                    <button class="faq-question" aria-expanded="false">
                        Casino অ্যাপ কোথা থেকে ডাউনলোড করবো?
                        <span class="faq-arrow">&#9660;</span>
                    </button>
                    <div class="faq-answer">
                        Casino অ্যাপ অফিসিয়াল ওয়েবসাইট থেকে নিরাপদে ডাউনলোড করা যায়। এই মোবাইল অ্যাপের মাধ্যমে খেলোয়াড়রা সহজেই লগইন করে ক্যাসিনো গেম ও বেট উপভোগ করতে পারেন।
                    </div>
                </div>
                <div class="faq-item">
                    <button class="faq-question" aria-expanded="false">
                        আমি কি মোবাইল ফোনে Casino ব্যবহার করতে পারবো?
                        <span class="faq-arrow">&#9660;</span>
                    </button>
                    <div class="faq-answer">
                        অবশ্যই পারবেন! Casino অ্যাপ অ্যান্ড্রয়েড ও iOS উভয় ডিভাইসের জন্য অপ্টিমাইজ করা। এর মাধ্যমে আপনি যেকোনো জায়গা থেকে ক্যাসিনো গেমে বেট করতে পারবেন।
                    </div>
                </div>
                <div class="faq-item">
                    <button class="faq-question" aria-expanded="false">
                        Casino কি লাইভ ক্যাসিনো সাপোর্ট করে
                        <span class="faq-arrow">&#9660;</span>
                    </button>
                    <div class="faq-answer">
                        হ্যাঁ, Casino লাইভ ডিলার টেবিল এবং রিয়েল টাইম ক্যাসিনো সাপোর্ট করে। খেলোয়াড়রা সহজে অ্যাপ বা ওয়েবসাইট থেকে লগইন করে লাইভ বেটিং উপভোগ করতে পারেন।
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!-- Desktop Footer -->
    <footer class="footer-advanced">
  <div class="footer-container">
    <div class="footer-about">
        <a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" aria-label="Homepage" class="footer-logo-link">
        <img src="https://ik.imagekit.io/sm88/tunnel-brand/assets/images/logo-sm88.webp" alt="Casino Logo" title="Casino Casino Logo" class="footer-logo-img">
      </a>
      <h4>Casino <?= htmlspecialchars($pageTitleHome, ENT_QUOTES, 'UTF-8') ?></h4>
      <p>Casino <?= htmlspecialchars($pageDescHome, ENT_QUOTES, 'UTF-8') ?></p>
    </div>
    <div class="footer-links">
      <h4>Quick Links</h4>
      <ul>
        <li><a href="#login">বোনাস লগইন</a></li>
        <li><a href="#app">মোবাইল অ্যাপটি ডাউনলোড করুন</a></li>
        <li><a href="#casino">ক্যাসিনো গেম অনলাইন</a></li>
        <li><a href="#bd">বাংলাদেশ বেটিং প্ল্যাটফর্ম</a></li>
        <li><a href="#faq">FAQ</a></li>
      </ul>
    </div>
    <div class="footer-legal">
      <h4>Legal</h4>
      <ul>
        <li><a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>">About Us</a></li>
        <li><a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>">Terms &amp; Conditions</a></li>
        <li><a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>">Privacy Policy</a></li>
        <li><a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>">Responsible Gaming</a></li>
      </ul>
    </div>
    <div class="footer-social">
  <h4>Connect</h4>
  <div class="social-icons">
    <a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" aria-label="Facebook" target="_blank" rel="noopener">
      <!-- Facebook SVG -->
      <svg width="28" height="28" fill="none" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="#232946"/><path d="M17.458 14.53l.337-2.2h-2.095V10.87c0-.603.295-1.19 1.244-1.19h.964V7.748A11.73 11.73 0 0 0 16.13 7.66c-1.71 0-2.83 1.036-2.83 2.915v1.754h-1.902v2.2h1.902V21h2.35v-6.47h1.758z" fill="#fff"/></svg>
    </a>
    <a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" aria-label="Twitter" target="_blank" rel="noopener">
      <!-- Twitter SVG -->
      <svg width="28" height="28" fill="none" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="#232946"/><path d="M22.093 10.127a5.618 5.618 0 0 1-1.61.441 2.797 2.797 0 0 0 1.229-1.541 5.637 5.637 0 0 1-1.782.68 2.822 2.822 0 0 0-4.808 2.572A8.025 8.025 0 0 1 7.21 9.36a2.82 2.82 0 0 0 .872 3.77 2.806 2.806 0 0 1-1.277-.353v.036a2.822 2.822 0 0 0 2.264 2.767 2.805 2.805 0 0 1-1.273.048 2.825 2.825 0 0 0 2.637 1.96 5.664 5.664 0 0 1-3.508 1.21c-.228 0-.453-.013-.674-.04A8.021 8.021 0 0 0 13.34 20c5.094 0 7.885-4.22 7.885-7.883 0-.12-.003-.24-.009-.36a5.637 5.637 0 0 0 1.377-1.43z" fill="#fff"/></svg>
    </a>
    <a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" aria-label="Instagram" target="_blank" rel="noopener">
      <!-- Instagram SVG -->
      <svg width="28" height="28" fill="none" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="#232946"/><g><rect x="8" y="8" width="12" height="12" rx="4" stroke="#fff" stroke-width="2"/><circle cx="14" cy="14" r="3" stroke="#fff" stroke-width="2"/><circle cx="18.5" cy="9.5" r="1" fill="#fff"/></g></svg>
    </a>
    <a href="<?= htmlspecialchars($canonicalUrl, ENT_QUOTES, 'UTF-8') ?>" aria-label="Telegram" target="_blank" rel="noopener">
      <!-- Telegram SVG -->
      <svg width="28" height="28" fill="none" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="#232946"/><path d="M20.734 8.608c-.18-.148-.422-.178-.633-.078L7.01 14.485a.59.59 0 0 0 .04 1.092l2.951 1.137 1.136 2.951a.59.59 0 0 0 1.092.04l5.954-13.091a.589.589 0 0 0-.083-.748zm-6.01 9.91-1.09-2.835 5.454-4.099-4.364 6.934zm.25-1.364-1.805-.695-2.26-.872 10.181-3.921-6.116 5.488zm-2.24-1.283 2.284.89 5.393-6.028-7.677 5.138z" fill="#fff"/></svg>
    </a>
  </div>
</div>

  </div>
  <div class="footer-bottom">
    &copy; 2025 Casino. All rights reserved. Soyo.
  </div>
</footer>
    <!-- Fixed Mobile Footer -->
    <footer class="fixed-footer">
        <nav class="footer-nav">
            <a href="https://sm88login.com/login/" class="footer-button">
                <!-- Sign Up Icon: User Plus -->
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="currentColor"
                     stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M16 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                    <circle cx="9" cy="7" r="4"/>
                    <line x1="19" y1="8" x2="19" y2="14"/>
                    <line x1="22" y1="11" x2="16" y2="11"/>
                </svg>
                <span>Sign Up</span>
            </a>
            <a href="https://sm88login.com/login/" class="footer-button">
                <!-- Login Icon: Log In -->
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="currentColor"
                     stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"/>
                    <polyline points="10 17 15 12 10 7"/>
                    <line x1="15" y1="12" x2="3" y2="12"/>
                </svg>
                <span>Login</span>
            </a>
            <a href="https://sm88login.com/login/" class="footer-button">
                <!-- Bonus Icon: Gift -->
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="currentColor"
                     stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect x="2" y="7" width="20" height="14" rx="2" ry="2"/>
                    <path d="M16 3a4 4 0 0 1 0 8H8a4 4 0 0 1 0-8"/>
                    <line x1="12" y1="7" x2="12" y2="21"/>
                </svg>
                <span>Bonus</span>
            </a>
        </nav>
    </footer>
    <!-- External JS -->
    <script src="https://ik.imagekit.io/soyo/BD/tunnel/asset2/main.js"></script>
</body>
</html>
